/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.Producer;
import java.lang.management.ManagementPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Timer;
import javax.management.MBeanServer;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.NoSuchProducerException;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.VMJFR;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.EventHandler;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.RequestableEventEnvironment;

@Deprecated
public abstract class JFR {
    static final int NATIVE_ID_HIGHEST = 4096;
    static final String DEFAULT_RECORDING_NAME = "HotSpot default";
    static final Long DEFAULT_RECORDING_ID = 0L;
    static final String JAVA_HOME;
    static final String JAVA_IO_TMPDIR;
    public static final long INVALID_THRESHOLD = -1L;
    public static final long INVALID_PERIOD = -1L;
    public static final int JVM_PRODUCER_ID = 1;
    private static final Object singletonLock;
    private static boolean isLinked;
    private static volatile JFR jfr;
    static Producer producer;
    protected static final int addressSize;
    private static final Permission controlPermission;
    private static final Permission monitorPermission;

    static void checkControl() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(controlPermission);
        }
    }

    static void checkMonitor() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(monitorPermission);
        }
    }

    static InternalError cannotHappen(Throwable throwable) {
        return (InternalError)new InternalError(throwable.getMessage()).initCause(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JFR get() {
        JFR.checkControl();
        Object object = singletonLock;
        synchronized (object) {
            if (null == jfr) {
                JFR.tryLazyStart();
            }
            assert (jfr != null);
            return jfr;
        }
    }

    private static void tryLazyStart() {
        assert (Thread.holdsLock(singletonLock));
        assert (null == jfr);
        JFR.checkPreConditionsForAttemptedStart();
        assert (isLinked);
        assert (JFR.isSupportedInVM());
        assert (JFR.isCommercialFeaturesUnlocked());
        assert (!JFR.isDisabledOnCommandLine());
        assert (!JFR.isStarted());
        JFR.startInternal();
    }

    private static void checkPreConditionsForAttemptedStart() {
        assert (Thread.holdsLock(singletonLock));
        if (!isLinked) {
            String string = "An unsatisfied link error has occured trying to load the jfr native library.";
            string = string + " Please make sure the virtual machine can locate this required native library.";
            throw new LinkageError(string);
        }
        if (!JFR.isSupportedInVM()) {
            throw new UnsupportedOperationException("The virtual machine does not support this version of Java Flight Recorder.");
        }
        if (!JFR.isCommercialFeaturesUnlocked()) {
            String string = "Java Flight Recorder is a commercial feature, ";
            string = string + "and will need to be unlocked before use via the UnlockCommercialFeatures flag. ";
            string = string + "UnlockCommercialFeatures can be set at startup via the command-line, or during ";
            string = string + "runtime through jcmd and JMX interfaces.";
            throw new IllegalStateException(string);
        }
        if (JFR.isDisabledOnCommandLine()) {
            String string = "Java Flight Recorder can not start because it ";
            string = string + "has been disabled using the -XX:-FlightRecorder flag on the command-line.";
            throw new IllegalStateException(string);
        }
    }

    private static void startInternal() {
        assert (Thread.holdsLock(singletonLock));
        boolean bl = false;
        try {
            bl = JFR.startFlightRecorder();
        }
        finally {
            if (!bl) {
                JFR.restoreAndThrowOnFailedStartAttempt();
            }
        }
        assert (jfr != null && jfr instanceof VMJFR);
    }

    private static void restoreAndThrowOnFailedStartAttempt() throws IllegalStateException {
        assert (Thread.holdsLock(singletonLock));
        if (jfr != null) {
            jfr = null;
        }
        throw new IllegalStateException("Java Flight Recorder could not be started at this time.");
    }

    private static Thread createAndRegisterShutdownHookThread(final VMJFR vMJFR, final Logger logger) {
        final Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.debug("Shutdown hook: destroy java");
                vMJFR.destroy();
                logger.debug("Shutdown hook: shutdown native");
                vMJFR.shutdown();
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(thread);
                return null;
            }
        }, null, new RuntimePermission("shutdownHooks"));
        logger.trace("Shutdown hook registered");
        return thread;
    }

    private static void unregisterShutdownHook(final Thread thread, Logger logger) {
        assert (thread != null);
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Runtime.getRuntime().removeShutdownHook(thread);
            }
        }, null, new RuntimePermission("shutdownHooks"));
        if (bl) {
            logger.trace("Shutdown hook unregistered");
        }
    }

    private static void unregisterProducers(Logger logger) {
        if (producer != null && producer.isRegistered()) {
            try {
                logger.debug("unregistering producer");
                producer.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (jfr != null) {
            logger.debug("unregistering MetaProducer");
            ((JFRImpl)jfr).unregisterMetaProducer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JFR init() {
        assert (null == jfr);
        assert (null == producer);
        Logger logger = Logger.loggerFor("jfr");
        Thread thread = null;
        try {
            jfr = VMJFR.create();
            if (null == jfr) {
                return null;
            }
            assert (jfr != null && jfr instanceof VMJFR);
            VMJFR vMJFR = (VMJFR)jfr;
            vMJFR.createMetaProducer();
            producer = new Producer("Java Runtime", "Java Runtime", "http://www.oracle.com/hotspot/jdk/");
            vMJFR.instrument();
            producer.register();
            thread = JFR.createAndRegisterShutdownHookThread(vMJFR, logger);
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            try {
                JFR.unregisterProducers(logger);
                if (jfr != null) {
                    jfr.clear();
                }
            }
            catch (Exception exception) {
            }
            finally {
                producer = null;
                jfr = null;
                if (thread != null) {
                    JFR.unregisterShutdownHook(thread, logger);
                }
                logger.warn("JFR initialization attempt failed.");
                if (string != null) {
                    logger.warn(string);
                }
            }
        }
        return jfr;
    }

    JFR() {
        if (jfr != null) {
            throw new InternalError("JRA init sequence out of wack.");
        }
    }

    abstract void clear();

    static native boolean isSupportedInVM();

    static native boolean isCommercialFeaturesUnlocked();

    static native boolean isEnabled();

    static native boolean isStarted();

    private static native boolean isDisabledOnCommandLine();

    private static native boolean startFlightRecorder();

    public abstract FlightRecorder getMBean();

    public abstract void bind(MBeanServer var1);

    public abstract void unbind(MBeanServer var1);

    public abstract EventHandler createHandler(JavaEventDescriptor var1, Class<?> var2, Map<String, StringConstantPool> var3, RequestableEventEnvironment var4) throws InvalidEventDefinitionException;

    public abstract void addProducer(Producer var1, int var2, List<EventHandler> var3, Map<String, StringConstantPool> var4);

    public abstract void removeProducer(int var1);

    public abstract void addEventsToRegisteredProducer(Producer var1, int var2, List<EventHandler> var3, Map<String, StringConstantPool> var4);

    public abstract EventDescriptor getEvent(int var1) throws NoSuchEventException;

    public abstract ProducerDescriptor getProducer(int var1) throws NoSuchProducerException;

    public abstract Collection<ProducerDescriptor> getProducers();

    public abstract Collection<EventDescriptor> getEvents();

    public abstract int getpid();

    public abstract int nextID();

    public abstract Timer getTimer();

    protected abstract boolean storeConstpool(StringConstantPool var1);

    protected abstract void addConstpool(StringConstantPool var1);

    protected abstract void removeConstpool(StringConstantPool var1);

    static {
        singletonLock = new Object();
        jfr = null;
        producer = null;
        Permission[] permissionArray = new Permission[]{new RuntimePermission("loadLibrary.jfr"), new PropertyPermission("java.home", "read"), new PropertyPermission("java.io.tmpdir", "read"), new PropertyPermission("sun.arch.data.model", "read")};
        final String[] stringArray = new String[3];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    System.loadLibrary("jfr");
                    isLinked = true;
                }
                catch (LinkageError linkageError) {
                    isLinked = false;
                }
                stringArray[0] = System.getProperty("java.home");
                stringArray[1] = System.getProperty("java.io.tmpdir");
                stringArray[2] = System.getProperty("sun.arch.data.model");
                return null;
            }
        }, null, permissionArray);
        JAVA_HOME = stringArray[0];
        JAVA_IO_TMPDIR = stringArray[1];
        String string = stringArray[2];
        assert (string != null);
        addressSize = Integer.parseInt(string) / 8;
        controlPermission = new ManagementPermission("control");
        monitorPermission = new ManagementPermission("monitor");
    }
}

