/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.IntSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.AbstractPipeline;
import java.util.stream.DoublePipeline;
import java.util.stream.DoubleStream;
import java.util.stream.FindOps;
import java.util.stream.ForEachOps;
import java.util.stream.IntStream;
import java.util.stream.LongPipeline;
import java.util.stream.LongStream;
import java.util.stream.MatchOps;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReduceOps;
import java.util.stream.ReferencePipeline;
import java.util.stream.Sink;
import java.util.stream.SliceOps;
import java.util.stream.SortedOps;
import java.util.stream.Stream;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.StreamSpliterators;
import java.util.stream.Tripwire;

abstract class IntPipeline<E_IN>
extends AbstractPipeline<E_IN, Integer, IntStream>
implements IntStream {
    IntPipeline(Supplier<? extends Spliterator<Integer>> supplier, int n, boolean bl) {
        super(supplier, n, bl);
    }

    IntPipeline(Spliterator<Integer> spliterator, int n, boolean bl) {
        super(spliterator, n, bl);
    }

    IntPipeline(AbstractPipeline<?, E_IN, ?> abstractPipeline, int n) {
        super(abstractPipeline, n);
    }

    private static IntConsumer adapt(Sink<Integer> sink) {
        if (sink instanceof IntConsumer) {
            return (IntConsumer)((Object)sink);
        }
        if (Tripwire.ENABLED) {
            Tripwire.trip(AbstractPipeline.class, "using IntStream.adapt(Sink<Integer> s)");
        }
        return sink::accept;
    }

    private static Spliterator.OfInt adapt(Spliterator<Integer> spliterator) {
        if (spliterator instanceof Spliterator.OfInt) {
            return (Spliterator.OfInt)spliterator;
        }
        if (Tripwire.ENABLED) {
            Tripwire.trip(AbstractPipeline.class, "using IntStream.adapt(Spliterator<Integer> s)");
        }
        throw new UnsupportedOperationException("IntStream.adapt(Spliterator<Integer> s)");
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.INT_VALUE;
    }

    @Override
    final <P_IN> Node<Integer> evaluateToNode(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl, IntFunction<Integer[]> intFunction) {
        return Nodes.collectInt(pipelineHelper, spliterator, bl);
    }

    @Override
    final <P_IN> Spliterator<Integer> wrap(PipelineHelper<Integer> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
        return new StreamSpliterators.IntWrappingSpliterator<P_IN>(pipelineHelper, supplier, bl);
    }

    final Spliterator.OfInt lazySpliterator(Supplier<? extends Spliterator<Integer>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator.OfInt((Supplier<Spliterator.OfInt>)supplier);
    }

    @Override
    final void forEachWithCancel(Spliterator<Integer> spliterator, Sink<Integer> sink) {
        Spliterator.OfInt ofInt = IntPipeline.adapt(spliterator);
        IntConsumer intConsumer = IntPipeline.adapt(sink);
        while (!sink.cancellationRequested() && ofInt.tryAdvance(intConsumer)) {
        }
    }

    @Override
    final Node.Builder<Integer> makeNodeBuilder(long l, IntFunction<Integer[]> intFunction) {
        return Nodes.intBuilder(l);
    }

    @Override
    public final PrimitiveIterator.OfInt iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfInt spliterator() {
        return IntPipeline.adapt(super.spliterator());
    }

    @Override
    public final LongStream asLongStream() {
        return new LongPipeline.StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedInt<Long>(sink){

                    @Override
                    public void accept(int n) {
                        this.downstream.accept((long)n);
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream asDoubleStream() {
        return new DoublePipeline.StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedInt<Double>(sink){

                    @Override
                    public void accept(int n) {
                        this.downstream.accept((double)n);
                    }
                };
            }
        };
    }

    @Override
    public final Stream<Integer> boxed() {
        return this.mapToObj(Integer::valueOf);
    }

    @Override
    public final IntStream map(final IntUnaryOperator intUnaryOperator) {
        Objects.requireNonNull(intUnaryOperator);
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedInt<Integer>(sink){

                    @Override
                    public void accept(int n) {
                        this.downstream.accept(intUnaryOperator.applyAsInt(n));
                    }
                };
            }
        };
    }

    @Override
    public final <U> Stream<U> mapToObj(final IntFunction<? extends U> intFunction) {
        Objects.requireNonNull(intFunction);
        return new ReferencePipeline.StatelessOp<Integer, U>(this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<U> sink) {
                return new Sink.ChainedInt<U>(sink){

                    @Override
                    public void accept(int n) {
                        this.downstream.accept(intFunction.apply(n));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream mapToLong(final IntToLongFunction intToLongFunction) {
        Objects.requireNonNull(intToLongFunction);
        return new LongPipeline.StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedInt<Long>(sink){

                    @Override
                    public void accept(int n) {
                        this.downstream.accept(intToLongFunction.applyAsLong(n));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapToDouble(final IntToDoubleFunction intToDoubleFunction) {
        Objects.requireNonNull(intToDoubleFunction);
        return new DoublePipeline.StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedInt<Double>(sink){

                    @Override
                    public void accept(int n) {
                        this.downstream.accept(intToDoubleFunction.applyAsDouble(n));
                    }
                };
            }
        };
    }

    @Override
    public final IntStream flatMap(final IntFunction<? extends IntStream> intFunction) {
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedInt<Integer>(sink){

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(int n2) {
                        try (IntStream intStream = (IntStream)intFunction.apply(n2);){
                            if (intStream != null) {
                                intStream.sequential().forEach(n -> this.downstream.accept(n));
                            }
                        }
                    }
                };
            }
        };
    }

    @Override
    public IntStream unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Integer> sink) {
                return sink;
            }
        };
    }

    @Override
    public final IntStream filter(final IntPredicate intPredicate) {
        Objects.requireNonNull(intPredicate);
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedInt<Integer>(sink){

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(int n) {
                        if (intPredicate.test(n)) {
                            this.downstream.accept(n);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final IntStream peek(final IntConsumer intConsumer) {
        Objects.requireNonNull(intConsumer);
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, 0){

            @Override
            Sink<Integer> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedInt<Integer>(sink){

                    @Override
                    public void accept(int n) {
                        intConsumer.accept(n);
                        this.downstream.accept(n);
                    }
                };
            }
        };
    }

    @Override
    public final IntStream limit(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Long.toString(l));
        }
        return SliceOps.makeInt(this, 0L, l);
    }

    @Override
    public final IntStream skip(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Long.toString(l));
        }
        if (l == 0L) {
            return this;
        }
        return SliceOps.makeInt(this, l, -1L);
    }

    @Override
    public final IntStream sorted() {
        return SortedOps.makeInt(this);
    }

    @Override
    public final IntStream distinct() {
        return this.boxed().distinct().mapToInt(n -> n);
    }

    @Override
    public void forEach(IntConsumer intConsumer) {
        this.evaluate(ForEachOps.makeInt(intConsumer, false));
    }

    @Override
    public void forEachOrdered(IntConsumer intConsumer) {
        this.evaluate(ForEachOps.makeInt(intConsumer, true));
    }

    @Override
    public final int sum() {
        return this.reduce(0, Integer::sum);
    }

    @Override
    public final OptionalInt min() {
        return this.reduce(Math::min);
    }

    @Override
    public final OptionalInt max() {
        return this.reduce(Math::max);
    }

    @Override
    public final long count() {
        return this.mapToLong(n -> 1L).sum();
    }

    @Override
    public final OptionalDouble average() {
        long[] lArray3 = this.collect(() -> new long[2], (lArray, n) -> {
            lArray[0] = lArray[0] + 1L;
            lArray[1] = lArray[1] + (long)n;
        }, (lArray, lArray2) -> {
            lArray[0] = lArray[0] + lArray2[0];
            lArray[1] = lArray[1] + lArray2[1];
        });
        return lArray3[0] > 0L ? OptionalDouble.of((double)lArray3[1] / (double)lArray3[0]) : OptionalDouble.empty();
    }

    @Override
    public final IntSummaryStatistics summaryStatistics() {
        return this.collect(IntSummaryStatistics::new, IntSummaryStatistics::accept, IntSummaryStatistics::combine);
    }

    @Override
    public final int reduce(int n, IntBinaryOperator intBinaryOperator) {
        return this.evaluate(ReduceOps.makeInt(n, intBinaryOperator));
    }

    @Override
    public final OptionalInt reduce(IntBinaryOperator intBinaryOperator) {
        return this.evaluate(ReduceOps.makeInt(intBinaryOperator));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> objIntConsumer, BiConsumer<R, R> biConsumer) {
        BinaryOperator binaryOperator = (object, object2) -> {
            biConsumer.accept(object, object2);
            return object;
        };
        return this.evaluate(ReduceOps.makeInt(supplier, objIntConsumer, binaryOperator));
    }

    @Override
    public final boolean anyMatch(IntPredicate intPredicate) {
        return this.evaluate(MatchOps.makeInt(intPredicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(IntPredicate intPredicate) {
        return this.evaluate(MatchOps.makeInt(intPredicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(IntPredicate intPredicate) {
        return this.evaluate(MatchOps.makeInt(intPredicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final OptionalInt findFirst() {
        return this.evaluate(FindOps.makeInt(true));
    }

    @Override
    public final OptionalInt findAny() {
        return this.evaluate(FindOps.makeInt(false));
    }

    @Override
    public final int[] toArray() {
        return (int[])Nodes.flattenInt((Node.OfInt)this.evaluateToArrayNode(Integer[]::new)).asPrimitiveArray();
    }

    static class Head<E_IN>
    extends IntPipeline<E_IN> {
        Head(Supplier<? extends Spliterator<Integer>> supplier, int n, boolean bl) {
            super(supplier, n, bl);
        }

        Head(Spliterator<Integer> spliterator, int n, boolean bl) {
            super(spliterator, n, bl);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int n, Sink<Integer> sink) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(IntConsumer intConsumer) {
            if (!this.isParallel()) {
                IntPipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(intConsumer);
            } else {
                super.forEach(intConsumer);
            }
        }

        @Override
        public void forEachOrdered(IntConsumer intConsumer) {
            if (!this.isParallel()) {
                IntPipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(intConsumer);
            } else {
                super.forEachOrdered(intConsumer);
            }
        }
    }

    static abstract class StatefulOp<E_IN>
    extends IntPipeline<E_IN> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> abstractPipeline, StreamShape streamShape, int n) {
            super(abstractPipeline, n);
            assert (abstractPipeline.getOutputShape() == streamShape);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<Integer> opEvaluateParallel(PipelineHelper<Integer> var1, Spliterator<P_IN> var2, IntFunction<Integer[]> var3);
    }

    static abstract class StatelessOp<E_IN>
    extends IntPipeline<E_IN> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> abstractPipeline, StreamShape streamShape, int n) {
            super(abstractPipeline, n);
            assert (abstractPipeline.getOutputShape() == streamShape);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }
}

