/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.config.Config;
import cech12.usefulhats.item.AbstractMiningHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IBreakSpeedChanger;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

public class MiningHatItem
extends AbstractMiningHatItem
implements IBreakSpeedChanger,
IUsefulHatModelOwner {
    public MiningHatItem() {
        super("mining_hat", HatArmorMaterial.MINING, MiningHatItem.rawColorFromRGB(255, 216, 0), Config.MINING_HAT_ENABLED, Config.MINING_HAT_DAMAGE_ENABLED);
    }

    private double[] getSpeedConfig() {
        double[] speedConfig = new double[]{Config.MINING_HAT_SPEED_WITH_EFFICIENCY_0.getValue(), Config.MINING_HAT_SPEED_WITH_EFFICIENCY_1.getValue(), Config.MINING_HAT_SPEED_WITH_EFFICIENCY_2.getValue(), Config.MINING_HAT_SPEED_WITH_EFFICIENCY_3.getValue(), Config.MINING_HAT_SPEED_WITH_EFFICIENCY_4.getValue(), Config.MINING_HAT_SPEED_WITH_EFFICIENCY_5.getValue()};
        return speedConfig;
    }

    @Override
    public void onItemToolTipEvent(ItemStack stack, List<ITextComponent> tooltip) {
        super.onItemToolTipEvent(stack, tooltip);
        int value = (int)(this.getEnchantmentValue(stack, this.getSpeedConfig()) * 100.0);
        tooltip.add(new TranslationTextComponent("item.usefulhats.mining_hat.desc.mining_speed", new Object[]{value}).func_211708_a(TextFormatting.BLUE));
        if (Config.MINING_HAT_NIGHT_VISION_ENABLED.getValue()) {
            tooltip.add(new TranslationTextComponent("item.usefulhats.mining_hat.desc.night_vision", new Object[0]).func_211708_a(TextFormatting.BLUE));
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!Config.MINING_HAT_NIGHT_VISION_ENABLED.getValue()) {
            return;
        }
        if (player.func_70660_b(Effects.field_76439_r) != null) {
            return;
        }
        for (ItemStack item : player.func_184214_aD()) {
            if (!item.getToolTypes().contains(ToolType.PICKAXE) || world.func_201696_r(player.func_180425_c()) >= 8) continue;
            player.func_195064_c(new EffectInstance(Effects.field_76439_r));
            if (field_77697_d.nextInt(20) == 0) {
                this.damageHatItemByOne(stack, player);
            }
            return;
        }
    }

    @Override
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed event, ItemStack headSlotItemStack) {
        if (!event.isCanceled() && event.getPlayer().func_184614_ca().getToolTypes().contains(ToolType.PICKAXE) && event.getState().isToolEffective(ToolType.PICKAXE)) {
            event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)this.getEnchantmentValue(headSlotItemStack, this.getSpeedConfig())));
        }
    }

    @Override
    public void onBreakEvent(BlockEvent.BreakEvent event, ItemStack headSlotItemStack) {
        if (!event.isCanceled() && event.getPlayer().func_184614_ca().getToolTypes().contains(ToolType.PICKAXE) && event.getState().isToolEffective(ToolType.PICKAXE)) {
            this.damageHatItemByOne(headSlotItemStack, event.getPlayer());
        }
    }
}

