/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.Config;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IItemFishedListener;
import cech12.usefulhats.item.ILivingDropsListener;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;

public class LuckyHatItem
extends AbstractHatItem
implements IItemFishedListener,
ILivingDropsListener,
IUsefulHatModelOwner {
    public LuckyHatItem() {
        super("lucky_hat", HatArmorMaterial.LUCKY, LuckyHatItem.rawColorFromRGB(72, 242, 0), Config.LUCKY_HAT_ENABLED, Config.LUCKY_HAT_DAMAGE_ENABLED);
        this.addAllowedEnchantment(Enchantments.field_151370_z);
        this.addAllowedEnchantment(Enchantments.field_185304_p);
    }

    private boolean isLuckOrUnluckActive(PlayerEntity player) {
        EffectInstance luck = player.func_70660_b(Effects.field_188425_z);
        EffectInstance unluck = player.func_70660_b(Effects.field_189112_A);
        return luck != null && luck.func_76459_b() > 0 || unluck != null && unluck.func_76459_b() > 0;
    }

    private boolean hasHatRelatedItemInHand(PlayerEntity player) {
        for (ItemStack item : player.func_184214_aD()) {
            if (!item.getToolTypes().contains(ToolType.AXE) && !(item.func_77973_b() instanceof FishingRodItem) && !(item.func_77973_b() instanceof SwordItem)) continue;
            return true;
        }
        return false;
    }

    private int getEffectLevel(ItemStack stack) {
        return 1 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)stack) + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151370_z, (ItemStack)stack);
    }

    @Override
    public void onItemToolTipEvent(ItemStack stack, List<ITextComponent> tooltip) {
        super.onItemToolTipEvent(stack, tooltip);
        tooltip.add(new TranslationTextComponent("item.usefulhats.lucky_hat.desc.luck", new Object[]{UsefulHatsUtils.getRomanNumber(this.getEffectLevel(stack), false)}).func_211708_a(TextFormatting.BLUE));
        if (Config.LUCKY_HAT_UNLUCK_ENABLED.getValue()) {
            tooltip.add(new TranslationTextComponent("item.usefulhats.lucky_hat.desc.unluck", new Object[0]).func_211708_a(TextFormatting.RED));
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (this.isLuckOrUnluckActive(player)) {
            return;
        }
        if (this.hasHatRelatedItemInHand(player)) {
            player.func_195064_c(new EffectInstance(Effects.field_188425_z, 0, this.getEffectLevel(stack) - 1, false, false, true));
        }
    }

    @Override
    public void onItemFishedListener(ItemFishedEvent event, ItemStack headSlotItemStack) {
        if (this.isLuckOrUnluckActive(event.getPlayer())) {
            return;
        }
        if (!event.isCanceled() && this.hasHatRelatedItemInHand(event.getPlayer())) {
            this.damageHatItemByOne(headSlotItemStack, event.getPlayer());
            if (Config.LUCKY_HAT_UNLUCK_ENABLED.getValue()) {
                event.getPlayer().func_195064_c(new EffectInstance(Effects.field_189112_A, 200));
            }
        }
    }

    @Override
    public void onLivingDropsEvent(LivingDropsEvent event, PlayerEntity dropReason, ItemStack headSlotItemStack) {
        if (this.isLuckOrUnluckActive(dropReason)) {
            return;
        }
        if (!event.isCanceled() && this.hasHatRelatedItemInHand(dropReason)) {
            this.damageHatItemByOne(headSlotItemStack, dropReason);
            if (Config.LUCKY_HAT_UNLUCK_ENABLED.getValue()) {
                dropReason.func_195064_c(new EffectInstance(Effects.field_189112_A, 200));
            }
        }
    }
}

