/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.config.ConfigType;
import cech12.usefulhats.helper.IEnabled;
import cech12.usefulhats.item.HatArmorMaterial;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractHatItem
extends ArmorItem
implements IEnabled,
IDyeableArmorItem {
    private final int initColor;
    private final ConfigType.Boolean enabledConfig;
    private final ConfigType.Boolean enabledDamageConfig;
    private ArrayList<Enchantment> allowedEnchantments = new ArrayList();
    private ArrayList<Enchantment> allowedAdditionalBookEnchantments = new ArrayList();

    public AbstractHatItem(String name, HatArmorMaterial material, int initColor, ConfigType.Boolean enabledConfig, ConfigType.Boolean enabledDamageConfig) {
        super((IArmorMaterial)material, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(ItemGroup.field_78037_j));
        this.setRegistryName(new ResourceLocation("usefulhats", name));
        this.initColor = initColor;
        this.enabledConfig = enabledConfig;
        this.enabledDamageConfig = enabledDamageConfig;
        this.allowedEnchantments.add(Enchantments.field_185307_s);
        this.allowedEnchantments.add(Enchantments.field_185298_f);
        this.allowedEnchantments.add(Enchantments.field_185299_g);
        this.allowedAdditionalBookEnchantments.add(Enchantments.field_92091_k);
        this.allowedAdditionalBookEnchantments.add(Enchantments.field_185296_A);
        this.allowedAdditionalBookEnchantments.add(Enchantments.field_190941_k);
        this.allowedAdditionalBookEnchantments.add(Enchantments.field_190940_C);
    }

    protected static int rawColorFromRGB(int red, int green, int blue) {
        int rgb = Math.max(Math.min(255, red), 0);
        rgb = (rgb << 8) + Math.max(Math.min(255, green), 0);
        rgb = (rgb << 8) + Math.max(Math.min(255, blue), 0);
        return rgb;
    }

    @Override
    public boolean isEnabled() {
        return this.enabledConfig.getValue();
    }

    protected void addAllowedEnchantment(Enchantment enchantment) {
        this.allowedEnchantments.add(enchantment);
    }

    protected void addAllowedAdditionalBookEnchantment(Enchantment enchantment) {
        this.allowedAdditionalBookEnchantments.add(enchantment);
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99) ? compoundnbt.func_74762_e("color") : this.initColor;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        ArrayList<Enchantment> allowedE = new ArrayList<Enchantment>(this.allowedEnchantments);
        allowedE.addAll(this.allowedAdditionalBookEnchantments);
        for (Enchantment enchantment : EnchantmentHelper.func_82781_a((ItemStack)book).keySet()) {
            if (allowedE.contains(enchantment)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.allowedEnchantments.contains(enchantment);
    }

    protected void damageHatItemByOne(ItemStack stack, PlayerEntity entity) {
        if (!this.enabledDamageConfig.getValue()) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K && !entity.field_71075_bZ.field_75098_d && this.func_77645_m() && stack.func_96631_a(1, entity.func_70681_au(), entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null)) {
            entity.func_213361_c(EquipmentSlotType.HEAD);
            stack.func_190918_g(1);
            entity.func_71029_a(Stats.field_199088_e.func_199076_b((Object)this));
            stack.func_196085_b(0);
        }
    }

    @Deprecated
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType equipmentSlot) {
        return HashMultimap.create();
    }

    public void onItemToolTipEvent(ItemStack stack, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add(new TranslationTextComponent("item.modifiers." + EquipmentSlotType.HEAD.func_188450_d(), new Object[0]).func_211708_a(TextFormatting.GRAY));
    }
}

