/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.client;

import cech12.usefulhats.client.UsefulHatModel;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class UsefulHatLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends BipedArmorLayer<T, M, A> {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public UsefulHatLayer(IEntityRenderer<T, M> renderer, A hatModel) {
        super(renderer, hatModel, hatModel);
    }

    @Nonnull
    public ResourceLocation getArmorResource(@Nonnull Entity entity, ItemStack stack, @Nonnull EquipmentSlotType slot, @Nullable String type) {
        ResourceLocation resourceLocation;
        if (slot == EquipmentSlotType.HEAD && (resourceLocation = stack.func_77973_b().getRegistryName()) != null) {
            String texture = resourceLocation.func_110623_a();
            String domain = resourceLocation.func_110624_b();
            String s1 = String.format("%s:textures/models/usefulhats/%s%s.png", domain, texture, type == null ? "" : String.format("_%s", type));
            ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1);
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation(s1);
                ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
            }
            return resourcelocation;
        }
        return super.getArmorResource(entity, stack, slot, type);
    }

    public void func_225628_a_(@Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn, T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack hatItemStack = entityIn.func_184582_a(EquipmentSlotType.HEAD);
        Item hatItem = hatItemStack.func_77973_b();
        if (hatItem instanceof AbstractHatItem && hatItem instanceof IUsefulHatModelOwner) {
            super.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, entityIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    protected void func_188359_a(@Nonnull A model, EquipmentSlotType slotIn) {
        this.func_177194_a((BipedModel)model);
        if (slotIn == EquipmentSlotType.HEAD && model instanceof UsefulHatModel) {
            ((BipedModel)model).field_78116_c.field_78806_j = true;
            ((BipedModel)model).field_178720_f.field_78806_j = true;
        }
    }
}

