/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen.processor;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDreadBeast;
import com.github.alexthe666.iceandfire.entity.EntityDreadGhoul;
import com.github.alexthe666.iceandfire.entity.EntityDreadKnight;
import com.github.alexthe666.iceandfire.entity.EntityDreadScuttler;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.loot.LootTableList;

public class DreadRuinProcessor
implements ITemplateProcessor {
    private float integrity = 1.0f;
    public static final ResourceLocation DREAD_CHEST_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "mausoleum_chest"));

    public DreadRuinProcessor(BlockPos position, PlacementSettings settings, @Nullable Biome biome) {
    }

    @Nullable
    public Template.BlockInfo func_189943_a(World worldIn, BlockPos pos, Template.BlockInfo blockInfoIn) {
        if (worldIn.field_73012_v.nextFloat() <= this.integrity) {
            if (blockInfoIn.field_186243_b.func_177230_c() == IafBlockRegistry.dread_stone_bricks) {
                IBlockState state = DreadRuinProcessor.getRandomCrackedBlock(null, worldIn.field_73012_v);
                return new Template.BlockInfo(pos, state, null);
            }
            if (blockInfoIn.field_186243_b.func_177230_c() instanceof BlockChest) {
                ResourceLocation loot = DREAD_CHEST_LOOT;
                Random rand = new Random(worldIn.func_72905_C() + pos.func_177986_g());
                NBTTagCompound tag = blockInfoIn.field_186244_c == null ? new NBTTagCompound() : blockInfoIn.field_186244_c;
                tag.func_74778_a("LootTable", loot.toString());
                tag.func_74772_a("LootTableSeed", rand.nextLong());
                Template.BlockInfo newInfo = new Template.BlockInfo(pos, Blocks.field_150486_ae.func_176223_P(), tag);
                return newInfo;
            }
            if (blockInfoIn.field_186243_b.func_177230_c() == IafBlockRegistry.dread_spawner) {
                NBTTagCompound tag = blockInfoIn.field_186244_c == null ? new NBTTagCompound() : blockInfoIn.field_186244_c;
                NBTTagCompound spawnData = new NBTTagCompound();
                Random rand = new Random(worldIn.func_72905_C() + pos.func_177986_g());
                ResourceLocation spawnerMobId = EntityList.func_191306_a(this.getRandomMobForMobSpawner(rand));
                if (spawnerMobId != null) {
                    spawnData.func_74778_a("id", spawnerMobId.toString());
                    tag.func_82580_o("SpawnPotentials");
                    tag.func_74782_a("SpawnData", (NBTBase)spawnData.func_74737_b());
                }
                Template.BlockInfo newInfo = new Template.BlockInfo(pos, IafBlockRegistry.dread_spawner.func_176223_P(), tag);
                return newInfo;
            }
            return blockInfoIn;
        }
        return blockInfoIn;
    }

    private Class<? extends Entity> getRandomMobForMobSpawner(Random random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.3) {
            return EntityDreadThrall.class;
        }
        if ((double)rand < 0.5) {
            return EntityDreadGhoul.class;
        }
        if ((double)rand < 0.7) {
            return EntityDreadBeast.class;
        }
        if ((double)rand < 0.85) {
            return EntityDreadScuttler.class;
        }
        return EntityDreadKnight.class;
    }

    public static IBlockState getRandomCrackedBlock(@Nullable IBlockState prev, Random random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.5) {
            return IafBlockRegistry.dread_stone_bricks.func_176223_P();
        }
        if ((double)rand < 0.9) {
            return IafBlockRegistry.dread_stone_bricks_cracked.func_176223_P();
        }
        return IafBlockRegistry.dread_stone_bricks_mossy.func_176223_P();
    }
}

