/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonBanner;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonRider;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerGenericGlowing;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBlackFrostDragon
extends RenderLiving<EntityDragonBase> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/dread/black_frost.png");
    public static final ResourceLocation TEXTURE_EYES = new ResourceLocation("iceandfire:textures/models/dread/black_frost_eyes.png");

    public RenderBlackFrostDragon(RenderManager renderManager, ModelBase model, boolean fire) {
        super(renderManager, model, 0.8f);
        this.func_177094_a(new LayerGenericGlowing(this, TEXTURE_EYES));
        this.func_177094_a(new LayerDragonRider(this, true));
        this.func_177094_a(new LayerDragonBanner((RenderLivingBase)this));
    }

    public boolean shouldRender(EntityDragonBase dragon, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    protected void preRenderCallback(EntityDragonBase entity, float f) {
        this.field_76989_e = entity.getRenderSize() / 3.0f;
        GL11.glScalef((float)this.field_76989_e, (float)this.field_76989_e, (float)this.field_76989_e);
        float f7 = entity.prevDragonPitch + (entity.getDragonPitch() - entity.prevDragonPitch) * f;
        GL11.glRotatef((float)f7, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected ResourceLocation getEntityTexture(EntityDragonBase entity) {
        return TEXTURE;
    }
}

