/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public final class Predicates {
    private static final Joiner COMMA_JOINER = Joiner.on(",");

    public static <T> Predicate<T> alwaysTrue() {
        return ObjectPredicate.ALWAYS_TRUE.withNarrowedType();
    }

    static enum ObjectPredicate implements Predicate<Object>
    {
        ALWAYS_TRUE{

            @Override
            public boolean apply(@Nullable Object o) {
                return true;
            }
        }
        ,
        ALWAYS_FALSE{

            @Override
            public boolean apply(@Nullable Object o) {
                return false;
            }
        }
        ,
        IS_NULL{

            @Override
            public boolean apply(@Nullable Object o) {
                return o == null;
            }
        }
        ,
        NOT_NULL{

            @Override
            public boolean apply(@Nullable Object o) {
                return o != null;
            }
        };


        <T> Predicate<T> withNarrowedType() {
            return this;
        }
    }
}

